#include "General.h"
#include "VkillsCommand.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"
#include "SList.h"
#include "GameObjManager.h"
#include "engine_obj.h"

#define GREEN "104,234,40"

GameObject* Get_Part_Name_Fixed(const char *name1)
{
	SLNode<SmartGameObj> *x = GameObjManager::SmartGameObjList.Head();
	int count = 0;
	GameObject *current = 0;
	while (x)
	{
		GameObject *o = (GameObject *)x->Data();
		if (o && Commands->Is_A_Star(o))
		{
			const char *name = Get_Player_Name(o);
			if (stristr(name,name1))
			{
				current = o;
				count++;
			}
			delete[] name;
		}
		x = x->Next();
	}
	if ((count == 1) && (current) && (Commands->Get_ID(current)))
	{
		return current;
	}
	else
	{
		return 0;
	}
}

int Get_Part_Names_Fixed(const char *name1)
{
	SLNode<SmartGameObj> *x = GameObjManager::SmartGameObjList.Head();
	int count = 0;
	while (x)
	{
		GameObject *o = (GameObject *)x->Data();
		if (o && Commands->Is_A_Star(o))
		{
			const char *name = Get_Player_Name(o);
			if (stristr(name,name1))
			{
				count++;
			}
			delete[] name;
		}
		x = x->Next();
	}
	return count;
}

void Page(int ID, const char* rgb_colour, const char *Format, ...)
{
	if(ID < 1 || ID > 128)
	{
		return;
	}

	if (!Get_GameObj(ID))
	{
		return;
	}

	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	float Version = Get_Client_Version(ID);

	if(Version < 2.9)
	{
		Console("ppage %d %s",ID, buffer);
                return;
	}
	else
	{
		Console("cmsgp %d %s %s", ID, rgb_colour, buffer);
	}
}

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	Console_Input(buffer);
}

int Get_Team_Player_Count_Working(int Team)
{
	int Total = 0;
	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();

		if (p->IsActive)
		{
			int ID = p->PlayerId;
			if (Get_Team(ID) == Team)
			{
				Total++;
			}
		}
	}
	return Total;
}

VkillsCommand::VkillsCommand()
{
	RegisterEvent(EVENT_CHAT_HOOK,this);
}

VkillsCommand::~VkillsCommand()
{
	UnregisterEvent(EVENT_CHAT_HOOK,this);
}

bool VkillsCommand::OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
{
	if (Message[0] == L'!')
	{
		const char* Msg = StringClass(Message); //ALLOCATION
		if(!strcmp(Msg,"!vkills") || !strcmp(Msg,"!vehkills"))
		{
			cPlayer *x = Find_Player(PlayerID);

			Send_Client_Text(Message, Type, false, PlayerID, -1, true, true);
			Page(PlayerID, GREEN, "You have destroyed %d vehicle this match.", x->VehiclesDestroyed);

			return false;
		}
		char command[256];
		char checkname[256];
		int ret = sscanf(Msg, "%s %s", command, checkname);

		if(ret == 2)
		{
			if(!strcmp(command,"!vkills") || !strcmp(command,"!vehkills"))
			{
				int PartNames = Get_Part_Names_Fixed(checkname);

				if (PartNames > 1)
				{
					Send_Client_Text(Message, Type, false, PlayerID, -1, true, true);
					Page(PlayerID, GREEN, "Multiple players with this name found.");

					return false;
				}
				GameObject* checkobj = Get_Part_Name_Fixed(checkname);

				if(checkobj)
				{
					cPlayer *x = Find_Player((int)Get_Player_ID(checkobj));
					WideStringClass PlayerName = Find_Player(Get_Player_ID(checkobj))->PlayerName;

					Send_Client_Text(Message, Type, false, PlayerID, -1, true, true);
					Page(PlayerID, GREEN, "%S has destroyed %i vehicle(s) this match.", PlayerName, x->VehiclesDestroyed);

					return false;
				}
				else
				{
					Send_Client_Text(Message, Type, false, PlayerID, -1, true, true);
					Page(PlayerID, GREEN, "Player not Found.");

					return false;
				}
			}
		}
	}
	return true;
}

VkillsCommand vkillsCommand;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &vkillsCommand;
}
